

varying vec4 color;
varying float NdotL;
varying vec4 lmtexcoord;
varying vec3 normal;
varying vec3 normal1;
flat varying vec4 labvalue;

flat varying vec3 ambientLight;

const vec3 torchColor = vec3(3.000, 1.382, 0.408);
////
#define diagonal3(m) vec3((m)[0].x, (m)[1].y, m[2].z)

#define projMAD(m, v) (diagonal3(m) * (v) + (m)[3].xyz)
vec4 toClipSpace_dh(vec3 viewSpacePosition)
{
    return vec4(projMAD(dhProjection, viewSpacePosition), -viewSpacePosition.z);
}

vec3 applyDirectionalWeighting(vec3 center, vec3 left, vec3 right, vec3 up, vec3 down) {
    // Calculate weights and combine
    float weightCenter = 0.4;
    float weightSides = 0.15;
    float weightVerticals = 0.15;

    // Precompute combined values
    vec3 centerTerm = center * weightCenter;
    vec3 sideTerms = (left + right) * weightSides;
    vec3 verticalTerms = (up + down) * weightVerticals;

    return centerTerm + sideTerms + verticalTerms;
}
vec3 precomputeAmbientLight(vec3 wNormal, vec2 lightmap) {
    // Define directions
    const vec3 up = vec3(0.0, 1.0, 0.0);
    const vec3 left = vec3(-1.0, 0.0, 0.0);
    const vec3 left_50_up = vec3(-1.0, 0.5, 0.0);
    const vec3 forward = vec3(0.0, 0.0, 1.0);
    const vec3 forward_50_up = vec3(0.0, 0.5, 1.0);
    const vec3 right = vec3(1.0, 0.0, 0.0);
    const vec3 right_50_up = vec3(1.0, 0.5, 0.0);
    const vec3 backward = vec3(0.0, 0.0, -1.0);
    const vec3 backward_50_up = vec3(0.0, 0.5, -1.0);

    // Fetch sky colors from texture
    vec3 upS = skyFromTex2(up, colortex6).rgb;
    vec3 downS = skyFromTex2(-up, colortex6).rgb; 
    vec3 leftS0 = skyFromTex2(left, colortex6).rgb;
    vec3 leftS = skyFromTex2(left_50_up, colortex6).rgb;
    vec3 rightS0 = skyFromTex2(right, colortex6).rgb;
    vec3 rightS = skyFromTex2(right_50_up, colortex6).rgb;
    vec3 frontS0 = skyFromTex2(forward, colortex6).rgb;
    vec3 frontS = skyFromTex2(forward_50_up, colortex6).rgb;
    vec3 backS0 = skyFromTex2(backward, colortex6).rgb;
    vec3 backS = skyFromTex2(backward_50_up, colortex6).rgb;

    // Apply directional weighting
    vec3 ambientUp = applyDirectionalWeighting(upS, leftS, rightS, frontS, backS);
    vec3 ambientDown = applyDirectionalWeighting(downS, leftS, rightS, frontS, backS);
    vec3 ambientLeft = applyDirectionalWeighting(leftS, upS, leftS0, frontS, backS);
    vec3 ambientRight = applyDirectionalWeighting(rightS, upS, rightS0, frontS, backS);
    vec3 ambientF = applyDirectionalWeighting(frontS, upS, frontS0, leftS, rightS);
    vec3 ambientB = applyDirectionalWeighting(backS, upS, backS0, leftS, rightS);

    // Calculate average luminance
    float ambientA = luma((ambientUp + ambientLeft + ambientRight + ambientB + ambientF + ambientDown) / 6.0);

    // Normalize and clamp coefficients
    vec3 absNormal = abs(wNormal);
    float sumAbsNormal = dot(absNormal, vec3(1.0));
    vec3 ambientCoefs = wNormal / sumAbsNormal;
    vec3 clampedCoefs = max(ambientCoefs, 0.0);
    vec3 clampedCoefsNeg = max(-ambientCoefs, 0.0);

    // Calculate mix strength
    float mixstrength = clamp(pow(shadowblend, 0.3), 0.0, 1.0);
    float oneMinusMixStrength = 1.0 - mixstrength;

    // Determine skymap factor
#ifndef OVERWORLD
    float skymap = 1.0;
#else
    float skymap = lightmap.y;
#endif
    float skymap2 = skymap * skymap;

    // Adjust sides based on mix strength
    ambientRight = mix(ambientDown, ambientRight, mixstrength);
    ambientLeft = mix(ambientDown, ambientLeft, mixstrength);

    // Combine ambient lighting
    vec3 ambientCombined = (ambientUp * clampedCoefs.y +
                            ambientDown * clampedCoefsNeg.y +
                            ambientRight * clampedCoefs.x +
                            ambientLeft * clampedCoefsNeg.x +
                            ambientB * clampedCoefs.z +
                            ambientF * clampedCoefsNeg.z) *
                           skymap2 +
                           vec3(0.6 * ambientA * lmtexcoord.w);

#ifndef OVERWORLD
    ambientCombined *= 2.0;
#endif

    return ambientCombined;
}
vec4 getMaterialProperties(int blockType)
{
    // Reflectance, Smoothness, Subsurface amounts, and Porosity
    switch (blockType)
    {
    case 0: // DH_BLOCK_UNKNOWN
        return vec4(0.03, 0.1, 0.0, 0.07);
    case 1: // DH_BLOCK_LEAVES
        return vec4(0.03, 0.05, 0.5, 0.0);
    case 2: // DH_BLOCK_STONE
        return vec4(0.05, 0.3, 0.0, 0.03);
    case 3: // DH_BLOCK_WOOD
        return vec4(0.04, 0.25, 0.0, 0.04);
    case 4: // DH_BLOCK_METAL
        return vec4(0.9, 0.9, 0.0, 0.0);
    case 5: // DH_BLOCK_DIRT
        return vec4(0.04, 0.4, 0.0, 0.25);
    case 6: // DH_BLOCK_LAVA
        return vec4(0.7, 0.8, 0.5, 0.0);
    case 7: // DH_BLOCK_DEEPSLATE
        return vec4(0.05, 0.3, 0.0, 0.02);
    case 8: // DH_BLOCK_SNOW
        return vec4(0.05, 0.7, 0.25, 0.0);
    case 9: // DH_BLOCK_SAND
        return vec4(0.04, 0.4, 0.0, 0.25);
    case 10: // DH_BLOCK_TERRACOTTA
        return vec4(0.04, 0.35, 0.0, 0.03);
    case 11: // DH_BLOCK_NETHER_STONE
        return vec4(0.05, 0.3, 0.0, 0.03);
    case 12: // DH_BLOCK_WATER
        return vec4(0.0, 0.0, 0.0, 0.0);
    case 13:                             // DH_BLOCK_AIR
        return vec4(0.0, 0.0, 0.0, 0.0); // Should never be used
    case 14:                             // DH_BLOCK_ILLUMINATED
        return vec4(0.05, 0.6, 0.0, 0.01);
    default:
        return vec4(0.03, 0.1, 0.0, 0.07); // Default fallback
    }
}

void main()
{
    lmtexcoord.xyzw = vec4(gl_MultiTexCoord0.xy, gl_MultiTexCoord1.xy);
    color = gl_Color;
    labvalue = vec4(0);

    normal = gl_NormalMatrix * gl_Normal;
    normal1 = gl_Normal;

    labvalue = getMaterialProperties(dhMaterialId);

    ambientLight = precomputeAmbientLight(normal1, gl_MultiTexCoord1.xy);

    NdotL = clamp(dot(normal, sunVec), 0.0, 1.0);

    vec3 position = mat3(gl_ModelViewMatrix) * gl_Vertex.xyz + gl_ModelViewMatrix[3].xyz;

    gl_Position = taaFunc(toClipSpace_dh(position));
    // gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;
}
